<?php

/*

Plugin Name: Virtula Pay Rates Order

Plugin URI: https://virtula.md/ro/

Description: Plugin for order by rates - virtula.

Version: 1.1

Author: Virtula Dev

Author URI: https://virtula.md/ro/

License: GPLv2 or later

Text Domain: virtula

*/

  if ( ! defined( 'ABSPATH' ) ) {
    exit;
  }

  if ( ! function_exists( 'enqueue_related_pages_scripts_and_styles' ) ) :
    function enqueue_related_pages_scripts_and_styles() {
      // style enqueue
      wp_enqueue_style('custom-style', plugins_url( '/assets/css/style.css', __FILE__ ), array(), 'all');
      // scripts enqueue
      wp_enqueue_script('custom-scripts', plugins_url( '/assets/js/script.js', __FILE__ ), array( 'jquery' ), 'all');
    }

    add_action( 'wp_enqueue_scripts', 'enqueue_related_pages_scripts_and_styles');

  endif;

  // add_filter( 'woocommerce_cart_needs_payment', '__return_false' );
  add_filter('woocommerce_checkout_fields', 'custom_woocommerce_billing_fields');

  function custom_woocommerce_billing_fields($fields)
  {
      global $woocommerce;
      $lang = get_locale();
      $amount2 = floatval( preg_replace( '#[^\d.]#', '', $woocommerce->cart->get_cart_total() ) );

      if ($amount2 > 800 || $amount2 < 35000) {
        if ($lang == 'ru_RU') {
          $fields['billing']['billing_options'] = array(
            'label' => __('В 3 платежа <img src="https://virtula.md/static/images/landings/virtulamodule.png" style="max-width: 70px; display: inline;">', 'woocommerce'),
            'required' => false,
            'clear' => true,
            'type' => 'checkbox',
            'class' => array('virtula-checkbox'),
            'value' => get_post_meta($order->id, 'virtula', true ),
          );
        } else {
          $fields['billing']['billing_options'] = array(
            'label' => __('în 3 rate cu <img src="https://virtula.md/static/images/landings/virtulamodule.png" style="max-width: 70px; display: inline;">', 'woocommerce'),
            'required' => false,
            'clear' => true,
            'type' => 'checkbox',
            'class' => array('virtula-checkbox'),
            'value' => get_post_meta( $order->id, 'virtula', true ),
          );
        }
      } else {
        return null;
      }

      return $fields;
  }

  add_action( 'woocommerce_admin_order_data_after_shipping_address', 'my_custom_checkout_field_display_admin_order_meta', 10, 1 );

  function my_custom_checkout_field_display_admin_order_meta($order) {
    echo '<h3><strong>'.__('Virtula Selected').':</strong> ' . get_post_meta( $order->get_id(), '_billing_options', 'yes' ) . '</h3>';
  }
    
  add_action( 'woocommerce_thankyou', 'thankyou_delated_external_redirection', 5, 1 );

  function thankyou_delated_external_redirection( $order_id ) {
      if( !$order_id ){
          return;
      }

      $order          = wc_get_order( $order_id ); // Instannce of the WC_Order Object
      
      // echo "<script>console.log('Order: " . $order . "' );</script>";
      $custom_field = $order->get_meta('_billing_options');

      $order_total    = round($order->get_total()); // Order total amount

      // echo "<script>console.log('Custom field: " . $custom_field . "' );</script>";

      if ($custom_field == '1') {
        
        $link_redirect  = 'https://virtula.md/ro/cabinet_form'; // Base url
        $link_redirect .= '?amount='.$order_total; // passed variables
        ?>
          <script>
            jQuery(function($){
                // Redirect with a delay of 5 seconds
                setTimeout(function(){
                    window.location.href = '<?php echo $link_redirect; ?>';
                }, 5000);
            });
          </script>
        <?php

      }
  }

?>
